class Respawnables_DamageMutator extends Mutator config(Respawnables);

var bool Init;
var Respawnables_PRI PRI;

function PostBeginPlay()
{
	if (Init)
		return;
	Init = True;

	Level.Game.RegisterDamageMutator(Self);
}

function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{

	//Check for special stuff for Instigator:
	if ( InstigatedBy.IsA('PlayerPawn') )
		{
		if ( Respawnables_PRI(PlayerPawn(InstigatedBy).PlayerReplicationInfo).bHasDoubleDamage )
			{
			ActualDamage *= 2;
			}
		}
		
	//Check for special stuff for Victim:
	if ( Victim.IsA('PlayerPawn') )
		{
		if ( Respawnables_PRI(PlayerPawn(Victim).PlayerReplicationInfo).bHasShield )
			{
			ActualDamage *= 0.5;
			}
		else if ( InStr(Respawnables_PRI(PlayerPawn(Victim).PlayerReplicationInfo).InventoryString, "!RD") != -1 )
			{
			ActualDamage *= 0.25;
			}
		}
		
	if ( NextDamageMutator != None )
     		NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);
}

defaultproperties
{
}
